/* Created by Anjuta version 0.1.8 */
/*	This file will not be overwritten */

#include <stdio.h>
#include <unistd.h>
#include <stdint.h>
#include <stdlib.h>
#include <errno.h>
#include <ctype.h>
#include <string.h>

#include <sys/io.h>

#define LPT 0x378

#define led1 0x1
#define led2 0x2
#define led3 0x4
#define led4 0x8

long int numled;
int OnOff;

void
set_nouvelle_valeur(long int _numled, int _OnOff);
void 
bit_set (unsigned char* bits, int pos, int etat);

void 
bit_set (unsigned char* bits, int pos, int etat)
{
		unsigned char masque;
		int i;
		
		masque = 0x80;
		
		for (i=0; i<(pos % 8); i++)
				masque = masque >> 1;
		
		if (etat)
				bits[pos/8] = bits[pos / 8] | masque;
		else
		{
				bits[pos/8] = bits[pos/8] & (~masque);
		}
		return;
}

void set_nouvelle_valeur(long int _numled, int _OnOff)
{
		unsigned char state_byte;
		
		if (_numled < 9)
		{
				state_byte = inb(LPT);
				bit_set(&state_byte,_numled-1,_OnOff);
				outb(state_byte,LPT);
		}
		else
		{
				if (_numled==9) 
				{
						_numled=16;
						_OnOff= OnOff?0:1 ;
				}
				if (_numled==10) 
				{
						_numled=15;
						_OnOff= OnOff?0:1 ;
				}
				
				if (_numled==11) _numled=14;
				
				if (_numled==12) 
				{
						_numled=13;
						_OnOff= OnOff?0:1 ;
				}
				state_byte = inb(LPT+2);
				bit_set(&state_byte,_numled-9,_OnOff);
				outb(state_byte,LPT+2);
		}

}

int main(int argc, char** argv)
{
		if (iopl(3)) 
		{
				perror(strerror(errno));
				exit(1);
		}

		
		if (argc < 3) {fprintf(stderr,"setled: mauvais nombre de paramtre\n"); exit(1) ;};
		
		errno = 0;
		numled = strtol(argv[1],NULL,10);
		if (errno) {fprintf (stderr,"setled: Overflow\n");exit(1);}

		if ( numled == 0) {fprintf(stderr,"setled: le premier paramtre n'est pas un nombre ou est gal  zro \n"); exit(1) ;};
		//if (strtol(argv[1],NULL,10) > 12) {fprintf(stderr,"setled: le premier paramtre est suprieur  12"); exit(1) ;};
		
		if ((strcmp(argv[2],"ON") == 0) || (strcmp(argv[2],"on") == 0))
		{
				OnOff = 1;
		}
		else if ( (strcmp(argv[2],"OFF") == 0) || (strcmp(argv[2],"off") == 0) )
		{
				OnOff = 0;
		}
		else
		{
				fprintf(stderr,"setled: le deuxime paramtre est inconnu\n"); 
				exit(1) ;
		}
		
		set_nouvelle_valeur(numled, OnOff);
		
		return 0;
}
