#!/usr/bin/perl

################################################################################
# Script for mutt to add aliases to the mutt alias file and the abook
# addressbook at the same time.  Written by Brian Foley <brianf@maths.tcd.ie>
# If you improve/change this script, please send me a copy.
#
# To use put the following lines in your muttrc:
# macro index a "C<$TMP_FILE>\n\n!<abookadd.pl>\n" "create an alias from a message sender"
# macro pager a "C<$TMP_FILE>\n\n!<abookadd.pl>\n" "create an alias from a message sender"
#
# You must replace <$TMP_FILE> with the absolute path of the temporary file you 
# wish to use, and replace <abookadd.pl> with the absolute path of where you
# have located the abookadd.pl script
#
# You can also change the value of the $overwrite variable (default 1), this 
# will use vt100 control sequences to keep all the print statements on the same 
# line, as opposed to one under each other.  If you don't like this (or if it 
# messes up your terminal) set $overwrite to 0.
#
# This script will scan the headers for the headers "From:", "Sender:" and 
# "X-Sender:" in that order and use the first one it finds.  Addresses in the 
# following formats are allowed: "foo <foo@bar.com>", "<foo@bar.com>" and
# "foo@bar.com".
################################################################################


################################################################################
# variables you may need to change
################################################################################
$TMP_FILE="/home/intrigeri/.tmp/abookadd";
$ALIAS_FILE="/home/intrigeri/.mutt/aliases";
$ABOOK_FILE="/home/intrigeri/.abook/addressbook";
$overwrite=1;


################################################################################
# read in the files
################################################################################
open INPUT, "$TMP_FILE" or dienice("$!\n");
@lines = <INPUT>;
close INPUT;

open INPUT, "$ALIAS_FILE" or dienice("$!\n");
@aliases = <INPUT>;
close INPUT;

open INPUT, "$ABOOK_FILE" or dienice("$!\n");
@abook = <INPUT>;
close INPUT;


################################################################################
# mutt aliases stuff
################################################################################
if($overwrite){$overwrite = "M                                                                                \nM";}
else{$overwrite = "";}

foreach $line (@lines){
    if($line =~ /^From: /i){
        $fromline = $line;
        last;
    }
}
if($fromline eq ""){
    foreach $line (@lines){
        if($line =~ /^Sender: /i){
            $fromline = $line;
            last;
        }
    }
}
if($fromline eq ""){
    foreach $line (@lines){
        if($line =~ /^X-Sender: /i){
            $fromline = $line;
            last;
        }
    }
}
chomp($fromline);

print "Scanning....\n";

dienice("Could not extract senders data!\n") if($fromline eq "");

$fromline =~ s/<//i;
$fromline =~ s/>//i;
$fromline =~ /^(?:From|Sender|X-Sender):\s*((?:\S+\s+)*)((.+)\@.+)\s*$/;

dienice("Could not extract email address!\n") if(($2 eq "")||($3 eq ""));

print "$overwrite", "Alias as ($3):";    $nick = <>;    chomp ($nick);
$nick = $3 if($nick eq "");

foreach $alias (@aliases){
    if($alias =~ /^.*<.+\@.+>.*$/){
        chomp($alias);
        $alias =~ s/^alias //;
        $alias =~ s/ .*$//;
        dienice("You already have an alias defined with that name!\n") if($alias eq $nick);
    }
}


print "$overwrite", "Address ($2):";    $email = <>;    chomp ($email);
$email = $2 if($email eq "");

print "$overwrite", "Personal Name ($1):";    $name = <>;    chomp ($name);
$name = $1 if($name eq "");
while($name =~ /^\s*$/){
    print "$overwrite", "You must enter a personal name ($1):";    $name = <>;    chomp ($name);
}

$name =~ s/\s*$//;

print "$overwrite", "[$nick = $name <$email>] Accept? ([y]/n):";    $yesorno = <>;    chomp ($yesorno);
&dienice if(($yesorno ne "")&&($yesorno ne "y"));

open(SAVE,">>$ALIAS_FILE") or dienice("$!\n");
flock(SAVE,2);
seek(SAVE,0,2);
print SAVE "alias $nick $name <$email>\n";
close(SAVE);
print "$overwrite", "Alias added.\n";


################################################################################
# abook stuff
################################################################################
print "$overwrite", "Add details to abook? ([y]/n):";    $yesorno = <>;    chomp ($yesorno);
&dienice if(($yesorno ne "")&&($yesorno ne "y"));

foreach $line (@abook){
    if($line =~ /^email=.+$/){
        chomp($line);
        $line =~ s/^email=//;
        @addresses = split(/,/, $line);
        foreach $add (@addresses){
            dienice("You already have an abook entry defined with that email address!\n") if($add eq $email);
        }
    }
}

print "$overwrite", "Address:";    $address = <>;    chomp ($address);
print "$overwrite", "City:";    $city = <>;    chomp ($city);
print "$overwrite", "State:";    $state = <>;    chomp ($state);
print "$overwrite", "ZIP:";    $zip = <>;    chomp ($zip);
print "$overwrite", "Country:";    $country = <>;    chomp ($country);
print "$overwrite", "Phone:";    $phone = <>;    chomp ($phone);
print "$overwrite", "Work:";    $workphone = <>;    chomp ($workphone);
print "$overwrite", "Fax:";    $fax = <>;    chomp ($fax);
print "$overwrite", "Mobile:";    $mobile = <>;    chomp ($mobile);
print "$overwrite", "URL:";    $url = <>;    chomp ($url);
print "$overwrite", "Notes:";    $notes = <>;    chomp ($notes);

$biggest = 0;
foreach $line (@abook){
    if($line =~ /^\[.+\]$/){
        chomp($line);
        $line =~ s/\[//;
        $line =~ s/\]//;
        $biggest = $line if($line>$biggest)
    }
}
dienice("No data in file?!\n") if($biggest == 0);
$biggest++;

open(SAVE,">>$ABOOK_FILE") or dienice("$!\n");
flock(SAVE,2);
seek(SAVE,0,2);
print SAVE "[$biggest]\n";
print SAVE "name=$name\n" if($name ne "");
print SAVE "email=$email\n" if($email ne "");
print SAVE "address=$address\n" if($address ne "");
print SAVE "city=$city\n" if($city ne "");
print SAVE "state=$state\n" if($state ne "");
print SAVE "zip=$zip\n" if($zip ne "");
print SAVE "country=$country\n" if($country ne "");
print SAVE "phone=$phone\n" if($phone ne "");
print SAVE "workphone=$workphone\n" if($workphone ne "");
print SAVE "fax=$fax\n" if($fax ne "");
print SAVE "mobile=$mobile\n" if($mobile ne "");
print SAVE "nick=$nick\n" if($nick ne "");
print SAVE "url=$url\n" if($url ne "");
print SAVE "notes=$notes\n" if($notes ne "");
print SAVE "\n";
close(SAVE);

&dienice;

sub dienice {
    print "$overwrite", "@_";
    `rm -f $TMP_FILE`;
    exit;
}
